<?php

namespace UtillzCore\Inc\Src\Listing\Action\Modules\Button;

use \UtillzCore\Inc\Src\User;
use \UtillzCore\Inc\Src\Listing\Action\Modules\Module;
use \UtillzCore\Inc\Src\Listing\Listing;

class Button extends Module {

    public function get() {

        $this->before_get();

        if( isset( $this->props->hide_if_field_empty ) && $this->props->hide_if_field_empty == true ) {
            if( empty( Ucore()->get( $this->props->button_field, get_the_ID(), true ) ) ) {
                return;
            }
        }

        return $this->template();

    }

    public function controller() {

        $url = '#';
        $modal = $target = '';

        if( $this->props->botton_target_blank ) {
            if( ! $this->props->request_login || ( $this->props->request_login && is_user_logged_in() ) ) {
                $target = 'target="_blank"';
            }
        }

        if( ! $this->props->request_login || ( $this->props->request_login && is_user_logged_in() ) ) {
            if( $this->props->button_field ) {
                $url = esc_attr( Ucore()->get( $this->props->button_field, get_the_ID(), true ) );
            }
        }

        // if email
        if( filter_var( $url, FILTER_VALIDATE_EMAIL ) ) {
            $url = sprintf('mailto:%s', $url);
        }

        if( $this->props->request_login && ! is_user_logged_in() ) {
            $modal = 'data-modal="signin"';
        }

        global $ulz_listing;

        return array_merge( (array) $this->props, [
            'component' => $this->component,
            'listing' => new Listing( get_the_ID() ),
            'listing_id' => get_the_ID(),
            'target' => $target,
            'url' => $url,
            'modal' => $modal,
            'strings' => (object) [
                'label' => esc_html__( 'Button', 'utillz-core' )
            ],
        ]);

    }

}
